<?php

namespace App\Http\Controllers;

use App\DimxDim;
use App\SysxUser;
use Illuminate\Http\Request;
use App\IzinBermalam;

use App\Events\NotificationEvent;
use Illuminate\Support\Facades\DB;

class IzinBermalamController extends ResponseController
{
    //
    public function requestIzin(Request $request, $id)
    {

        $izin = new IzinBermalam;
        $izin->dim_id = $id;
        $izin->rencana_berangkat = $request->rencana_berangkat;
        $izin->rencana_kembali = $request->rencana_kembali;
        $izin->status_request_id = 1;
        $izin->desc = $request->desc;
        $izin->tujuan = $request->tujuan;
        if ($izin->save()) {
            return $this->successResponse(200, null,"Data berhasil disimpan");
        }else{
            return $this->errorResponse(404,null,"Data Tidak berhasil di simpan");
        }
    }
    public function getIzinBermalam($id)
    {
        $izin = IzinBermalam::leftJoin('hrdx_pegawai', function ($join) {
            $join->on('askm_izin_bermalam.keasramaan_id', '=', 'hrdx_pegawai.pegawai_id');
        })->where('dim_id', '=', $id)
        ->orderBy('izin_bermalam_id','DESC')
            ->get([
                'izin_bermalam_id as id_izin',
                'status_request_id as request_id',
                'nama as disetujui_oleh',
                'desc as keperluan_ib',
                'tujuan'
            ]);
//        var_dump($izin);
        return $this->successResponse(200, $izin);
    }
    public function getDetailIzinBermalam($id, $izinId)
    {
        $izin = DimxDim::leftJoin('askm_izin_bermalam',function ($join){
            $join->on('dimx_dim.dim_id','=','askm_izin_bermalam.dim_id');
        })->leftJoin('hrdx_pegawai',function($join){
            $join->on('askm_izin_bermalam.keasramaan_id','=','hrdx_pegawai.pegawai_id');
        })->where('dimx_dim.user_id','=',$id)
            ->where('askm_izin_bermalam.izin_bermalam_id','=',$izinId)
            ->first([
               'dimx_dim.nama as nama_mahasiswa',
               'dimx_dim.nim as nim_mahasiswa',
               'rencana_berangkat',
               'rencana_kembali',
               'realisasi_berangkat',
               'realisasi_kembali',
               'desc as keperluan_ib',
               'tujuan',
               'status_request_id as request_id',
               'hrdx_pegawai.nama as disetujui_oleh'
            ]);
        return $this->successResponse(200, $izin);
    }
    public function editIzinBermalam($izinId,$id,Request $request){
        $izin = IzinBermalam::where('izin_bermalam_id','=',$izinId)
        ->where('dim_id','=',$id)->first();
        $izin->rencana_berangkat =$izin->rencana_berangkat==null ? $izin->rencana_berangkat : $request->rencana_berangkat;
        $izin->rencana_kembali = $izin->rencana_kembali==null ? $izin->rencana_kembali : $request->rencana_kembali;
        $izin->desc = $izin->desc==null ? $izin->desc : $request->desc;
        $izin->tujuan = $izin->tujuan==null ? $izin->tujuan : $request->tujuan;
        $izin->save();
        return $this->successResponse(200,$izin,"Data Berhasil di update");
    }
    public function cancelIzinBermalam(Request $request){
        $izin = IzinBermalam::where('izin_bermalam_id','=',$request->idIzin)->first();
        $izin->status_request_id = 4;
        $izin->save();
        return $this->successResponse(200,null, "Izin sudah di batalkan");
    }
    public function approveOrNotIzinBermalam($idIzin,Request $request){
        $izin = IzinBermalam::where('izin_bermalam_id','=',$idIzin)->first();
        $izin->status_request_id = $request->status;
        $izin->save();
        if($izin->status_request_id == 2){
            
        $notif = new NotificationEvent();
            $notif->trigger("cis_channel","event-user-".$request->user_id,["msg"=>"Izin bermalam anda sudah di setujui oleh keasramaan"]);
        }else if($izin->status_request_id == 3){
            
        $notif = new NotificationEvent();
            $notif->trigger("cis_channel","event-user-".$request->user_id,["msg"=>"Izin bermalam anda ditolak oleh keasmraan"]);
        }
        return $this->successResponse(200,null,"Data sudah di update");
    }
}
